/*==============================================================================
HSReplication

This replicates the LlamaMessages, TauntMessages, PerfectMessages, and ClanTag
to the clients to display them on their HUD using the HSMessage UC File.
==============================================================================*/
class HSReplication expands ReplicationInfo;

var string HeadshotMessage[25];
var string PerfectMessage[25];
var string TauntMessage[10];
var string ClanTag;
var color HeadshotColor, TauntColor, PerfectColor;

replication
{
	reliable if ( Role == ROLE_Authority )
		ClanTag,
		HeadshotMessage,
		PerfectMessage,
		TauntMessage,
		HeadshotColor,
		TauntColor,
		PerfectColor;
}

simulated function PostNetBeginPlay()
{
	super.PostBeginPlay();
	SetTimer(1.0,true);
}

simulated function Tick(float DeltaTime)
{
	if ( Owner == None )
	{
		Destroy();
		return;
	}
}

simulated function Timer()
{
	local int i;

	class'HSMessage'.default.ClanTag = ClanTag;
	class'HSMessage'.default.HeadshotColor = HeadshotColor;
	class'HSMessage'.default.TauntColor = TauntColor;
	class'HSMessage'.default.PerfectColor = PerfectColor;

	for(i=0; i<ArrayCount(HeadshotMessage);i++)
	{
		if (HeadshotMessage[i] != "" )
			class'HSMessage'.default.HeadshotMessage[i] = HeadshotMessage[i];
		else break;
	}
	for(i=0; i<ArrayCount(PerfectMessage);i++)
	{
		if (PerfectMessage[i] != "" )
			class'HSMessage'.default.PerfectMessage[i] = PerfectMessage[i];
		else break;
	}
	for(i=0; i<ArrayCount(TauntMessage);i++)
	{
		if (TauntMessage[i] != "" )
			class'HSMessage'.default.TauntMessage[i] = TauntMessage[i];
		else break;
	}
}

defaultproperties
{
	RemoteRole=ROLE_SimulatedProxy
}
